/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import io.gitlab.jfronny.commons.throwable.ThrowingRunnable;
import io.gitlab.jfronny.commons.throwable.ThrowingSupplier;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigHolder;
import io.gitlab.jfronny.libjf.config.api.v2.EntryInfo;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.api.v2.type.Type;
import io.gitlab.jfronny.libjf.config.impl.commands.CommandEnv;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class JfConfigCommand {
    private static final String MOD_ID = "libjf-config-commands";
    private static final DynamicCommandExceptionType eType = new DynamicCommandExceptionType(o -> {
        if (o instanceof Throwable) {
            Throwable throwable = (Throwable)o;
            return class_2561.method_43470((String)("Could not execute command: " + throwable.getMessage()));
        }
        return class_2561.method_43470((String)"Could not execute command");
    });

    private static class_5250 text(String text) {
        return class_2561.method_43470((String)("[libjf-config-commands] " + text));
    }

    public static <S extends class_2172> void register(CommandEnv<S> env, String name) {
        LiteralArgumentBuilder<S> c_root = env.literal(name);
        LiteralArgumentBuilder c_config = (LiteralArgumentBuilder)((LiteralArgumentBuilder)env.literal("config").requires(env::isOperator)).executes(context -> {
            class_5250 text = JfConfigCommand.text("Loaded configs for:");
            ConfigHolder.getInstance().getRegistered().forEach((s, config) -> text.method_27693("\n- " + s));
            env.sendFeedback(context, (class_2561)text, false);
            return 1;
        });
        LiteralArgumentBuilder c_reload = (LiteralArgumentBuilder)env.literal("reload").executes(context -> {
            ConfigHolder.getInstance().getRegistered().forEach((mod, config) -> config.load());
            env.sendFeedback(context, (class_2561)JfConfigCommand.text("Reloaded configs"), true);
            return 1;
        });
        LiteralArgumentBuilder c_reset = (LiteralArgumentBuilder)env.literal("reset").executes(context -> {
            env.sendError(context, (class_2561)JfConfigCommand.text("Please specify a config to reset"));
            return 1;
        });
        ConfigHolder.getInstance().getRegistered().forEach((id, config) -> {
            c_reload.then(env.literal((String)id).executes(context -> {
                config.load();
                env.sendFeedback(context, (class_2561)JfConfigCommand.text("Reloaded config for " + id), true);
                return 1;
            }));
            JfConfigCommand.registerEntries(env, (ConfigCategory)config, Naming.get((String)id), c_config, c_reset, cns -> {
                LiteralArgumentBuilder c_instance = env.literal((String)id);
                cns.accept(c_instance);
                return c_instance;
            });
        });
        env.dispatcher().register((LiteralArgumentBuilder)c_root.then(((LiteralArgumentBuilder)c_config.then((ArgumentBuilder)c_reload)).then((ArgumentBuilder)c_reset)));
    }

    private static <S extends class_2172> void registerEntries(CommandEnv<S> env, ConfigCategory config, Naming naming, LiteralArgumentBuilder<S> c_config, LiteralArgumentBuilder<S> c_reset, Function<Consumer<LiteralArgumentBuilder<S>>, LiteralArgumentBuilder<S>> pathGen) {
        c_config.then((ArgumentBuilder)pathGen.apply(cns -> {
            cns.executes(context -> {
                env.sendFeedback(context, (class_2561)JfConfigCommand.text("").method_10852(naming.name()).method_27693(" is a category"), false);
                return 1;
            });
            for (EntryInfo entry : config.getEntries()) {
                JfConfigCommand.registerEntry(env, config, naming.entry(entry.getName()), cns, entry);
            }
        }));
        c_reset.then((ArgumentBuilder)pathGen.apply(cns -> {
            cns.executes(context -> {
                config.reset();
                env.sendFeedback(context, (class_2561)JfConfigCommand.text("Reset config for ").method_10852(naming.name()), true);
                return 1;
            });
            config.getPresets().forEach((id2, preset) -> cns.then(env.literal((String)id2).executes(context -> {
                preset.run();
                env.sendFeedback(context, (class_2561)JfConfigCommand.text("Loaded preset " + id2 + " for ").method_10852(naming.name()), true);
                return 1;
            })));
        }));
        config.getCategories().forEach((id2, cfg) -> JfConfigCommand.registerEntries(env, cfg, naming.category(id2), c_config, c_reset, cns -> (LiteralArgumentBuilder)pathGen.apply(cns1 -> {
            LiteralArgumentBuilder c_instance2 = env.literal((String)id2);
            cns.accept(c_instance2);
            cns1.then(c_instance2);
        })));
    }

    private static <T, S extends class_2172> void registerEntry(CommandEnv<S> env, ConfigCategory config, Naming.Entry naming, LiteralArgumentBuilder<S> cns, EntryInfo<T> entry) {
        if (!entry.supportsRepresentation()) {
            return;
        }
        LiteralArgumentBuilder c_entry = (LiteralArgumentBuilder)env.literal(entry.getName()).executes(context -> {
            class_2561 visualized = JfConfigCommand.visualizeOption(entry, naming, JfConfigCommand.tryRun(() -> ((EntryInfo)entry).getValue()));
            env.sendFeedback(context, (class_2561)JfConfigCommand.text("The value of ").method_10852(naming.name()).method_27693(" is ").method_10852(visualized), false);
            return 1;
        });
        ArgumentType<?> type = JfConfigCommand.getType(entry);
        if (type != null) {
            c_entry.then(env.argument("value", type).executes(context -> {
                Object value = context.getArgument("value", (Class)entry.getValueType().asClass());
                JfConfigCommand.tryRun(() -> {
                    entry.setValue(value);
                    config.getRoot().write();
                });
                env.sendFeedback(context, (class_2561)JfConfigCommand.text("Set ").method_10852(naming.name()).method_27693(" to ").method_10852(JfConfigCommand.visualizeOption(entry, naming, value)), true);
                return 1;
            }));
        } else {
            Object[] objectArray = entry.getValueType();
            if (objectArray instanceof Type.TEnum) {
                Type.TEnum te = (Type.TEnum)objectArray;
                for (Object value : te.options()) {
                    c_entry.then(env.literal(value.toString()).executes(context -> {
                        JfConfigCommand.tryRun(() -> {
                            entry.setValue(value);
                            config.getRoot().write();
                        });
                        env.sendFeedback(context, (class_2561)JfConfigCommand.text("Set ").method_10852(naming.name()).method_27693(" to ").method_10852(JfConfigCommand.visualizeOption(entry, naming, value)), true);
                        return 1;
                    }));
                }
            }
        }
        cns.then((ArgumentBuilder)c_entry);
    }

    private static <T> class_2561 visualizeOption(EntryInfo<T> entry, Naming.Entry naming, T value) {
        if (value == null) {
            return naming.nullValue();
        }
        Type type = entry.getValueType();
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TEnum.class, Type.TBool.class}, (Object)type, n)) {
            case 0 -> {
                Type.TEnum te = (Type.TEnum)type;
                yield naming.enumValue((Type)te, value);
            }
            case 1 -> {
                Type.TBool tb = (Type.TBool)type;
                yield naming.boolValue(((Boolean)value).booleanValue());
            }
            default -> class_2561.method_43470((String)String.valueOf(value));
        };
    }

    private static <T> ArgumentType<?> getType(EntryInfo<T> info) {
        Type type = info.getValueType();
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Type.TInt.class, Type.TLong.class, Type.TFloat.class, Type.TDouble.class, Type.TString.class, Type.TBool.class, Type.TEnum.class, Type.TUnknown.class}, (Object)type2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                Type.TInt ti = (Type.TInt)type2;
                yield IntegerArgumentType.integer((int)((int)info.getMinValue()), (int)((int)info.getMaxValue()));
            }
            case 1 -> {
                Type.TLong tl = (Type.TLong)type2;
                yield LongArgumentType.longArg((long)((long)info.getMinValue()), (long)((long)info.getMaxValue()));
            }
            case 2 -> {
                Type.TFloat tf = (Type.TFloat)type2;
                yield FloatArgumentType.floatArg((float)((float)info.getMinValue()), (float)((float)info.getMaxValue()));
            }
            case 3 -> {
                Type.TDouble td = (Type.TDouble)type2;
                yield DoubleArgumentType.doubleArg((double)info.getMinValue(), (double)info.getMaxValue());
            }
            case 4 -> {
                Type.TString ts = (Type.TString)type2;
                yield StringArgumentType.greedyString();
            }
            case 5 -> {
                Type.TBool tb = (Type.TBool)type2;
                yield BoolArgumentType.bool();
            }
            case 6 -> {
                Type.TEnum te = (Type.TEnum)type2;
                yield null;
            }
            case 7 -> {
                Type.TUnknown tu = (Type.TUnknown)type2;
                yield null;
            }
        };
    }

    private static <T> T tryRun(ThrowingSupplier<T, ?> supplier) throws CommandSyntaxException {
        return (T)supplier.orThrow(arg_0 -> ((DynamicCommandExceptionType)eType).create(arg_0)).get();
    }

    private static void tryRun(ThrowingRunnable<?> supplier) throws CommandSyntaxException {
        supplier.orThrow(arg_0 -> ((DynamicCommandExceptionType)eType).create(arg_0)).run();
    }
}

